
clear
set maxvar 10000

set more off

***********************************************************************
**** PREPARE EXTERNAL DATASETS
***********************************************************************

*Pew Religious Composition
import excel "Pew Religious Composition\Pew Religious Composition - to merge.xls", sheet("Sheet1") firstrow clear
replace country = "Bosnia" if country == "Bosnia-Herzegovina"
replace country = "Dominican Rep." if country == "Dominican Republic"
replace country = "Macedonia" if country == "Republic of Macedonia"
replace country = "Myanmar (Burma)" if country == "Burma (Myanmar)"
replace country = "Myanmar (Burma)" if country == "Burma (Myanmar)"
replace country = "Serbia (Yugoslavia)" if country == "Serbia"
replace country = "Slovak Republic" if country == "Slovakia"
replace country = "Timor" if country == "Timor-Leste"
replace country = "Trinidad & Tobago" if country == "Trinidad and Tobago"
replace country = "UAE" if country == "United Arab Emirates"
replace country = "UK" if country == "United Kingdom"
replace country = "USA" if country == "United States"
replace country = "Venezuala" if country == "Venezuela"
replace country = "Zaire (Dem Rep Congo)" if country == "Democratic Republic of the Congo"
save "Temp Pew Religious Composition.dta"


*World Bank GDP per capita
import excel "World Bank\GDP per capita - to merge.xls", sheet("Sheet1") firstrow clear
save "Temp WB GDP per capita.dta"

*World Bank Urban Population
import excel "World Bank\Urban Population - to merge.xls", sheet("Sheet1") firstrow clear
save "Temp WB Urban Population.dta"

*Polity IV
*note that there're duplicates for Ethiopia 1993 and Yugoslavie 1991 and they were dropped for this excel file 
import excel "Polity IV\Polity IV - to merge.xls", sheet("p4v2014") firstrow clear
*dropping code because Polity 3-digit name is different from WB or RAS
drop code
drop if year < 1990
rename polity2 polity
reshape wide polity, j(year) i(country)
replace country = "Congo-Brazzaville" if country == "Congo Brazzaville"
replace country = "Dominican Rep." if country == "Dominican Republic"
replace country = "Guinea Bissau" if country == "Guinea-Bissau"
replace country = "North Korea" if country == "Korea North"
replace country = "Serbia (Yugoslavia)" if country == "Serbia"
replace country = "South Korea" if country == "Korea South"
replace country = "Timor" if country == "East Timor"
replace country = "Trinidad & Tobago" if country == "Trinidad and Tobago"
replace country = "UK" if country == "United Kingdom"
replace country = "USA" if country == "United States"
replace country = "Venezuala" if country == "Venezuela"
save "Temp Polity IV.dta"


***********************************************************************
**** MERGE
***********************************************************************

use "RAS Project Round 3\The Religion and State Project, Main Dataset and Societal Module, Round 3.DTA", clear
recast str100 country

keep country ISO3 MXX* WSOCDISX* LXX* NXX* SAX* SBX* WGENERALX* WSOCREGX*
rename ISO3 code

drop 	MXX1990 MXX2014 ///
		WSOCDISX1990 WSOCDISX2014 ///
		LXX1990 LXX2014 ///
		NXX1990 NXX2014 ///
		SAX1990 SAX2014 ///
		SBX1990 SBX2014 ///
		WGENERALX1990 WGENERALX2014 ///
		WSOCREGX1990 WSOCREGX2014


*Merge with Pew Religious Composition
merge m:1 country using "Temp Pew Religious Composition.dta"
drop if _merge==2
drop _merge 
rm "Temp Pew Religious Composition.dta"

*Merge with World Bank GDP per capita
merge m:1 code using "Temp WB GDP per capita.dta"
drop if _merge==2
drop _merge 
rm "Temp WB GDP per capita.dta"

*Merge with World Bank Urban Population
merge m:1 code using "Temp WB Urban Population.dta"
drop if _merge==2
drop _merge 
rm "Temp WB Urban Population.dta"

*Merge with Polity IV
merge m:1 country using "Temp Polity IV.dta"
drop if _merge==2
drop _merge 
rm "Temp Polity IV.dta"



***********************************************************************
**** RENAME AND RECODE FOR MISSING VALUES
***********************************************************************


rename (MXX1990X MXX1991 MXX1992 MXX1993 MXX1994 MXX1995 MXX1996 MXX1997 MXX1998 MXX1999 ///
		MXX2000 MXX2001 MXX2002 MXX2003 MXX2004 MXX2005 MXX2006 MXX2007 MXX2008 MXX2009 ///
		MXX2010 MXX2011 MXX2012 MXX2013 MXX2014X) ///
	   (state1990 state1991 state1992 state1993 state1994 state1995 state1996 state1997 state1998 state1999 ///
	    state2000 state2001 state2002 state2003 state2004 state2005 state2006 state2007 state2008 state2009 ///
		state2010 state2011 state2012 state2013 state2014)

rename (WSOCDISX1990X WSOCDISX1991 WSOCDISX1992 WSOCDISX1993 WSOCDISX1994 WSOCDISX1995 WSOCDISX1996 WSOCDISX1997 WSOCDISX1998 WSOCDISX1999 ///
		WSOCDISX2000 WSOCDISX2001 WSOCDISX2002 WSOCDISX2003 WSOCDISX2004 WSOCDISX2005 WSOCDISX2006 WSOCDISX2007 WSOCDISX2008 WSOCDISX2009 ///
		WSOCDISX2010 WSOCDISX2011 WSOCDISX2012 WSOCDISX2013 WSOCDISX2014X) ///
	   (social1990 social1991 social1992 social1993 social1994 social1995 social1996 social1997 social1998 social1999 ///
	    social2000 social2001 social2002 social2003 social2004 social2005 social2006 social2007 social2008 social2009 ///
		social2010 social2011 social2012 social2013 social2014)

rename (LXX1990X LXX1991 LXX1992 LXX1993 LXX1994 LXX1995 LXX1996 LXX1997 LXX1998 LXX1999 ///
		LXX2000 LXX2001 LXX2002 LXX2003 LXX2004 LXX2005 LXX2006 LXX2007 LXX2008 LXX2009 ///
		LXX2010 LXX2011 LXX2012 LXX2013 LXX2014X) ///
	   (legislation1990 legislation1991 legislation1992 legislation1993 legislation1994 legislation1995 legislation1996 legislation1997 legislation1998 legislation1999 ///
	    legislation2000 legislation2001 legislation2002 legislation2003 legislation2004 legislation2005 legislation2006 legislation2007 legislation2008 legislation2009 ///
		legislation2010 legislation2011 legislation2012 legislation2013 legislation2014)		
			
		
gen muslim = 0
replace muslim = 1 if pctmuslim > .5 & pctmuslim < 1.1

drop code
gen ctyid = _n
reshape long state social legislation majority official support gensocietal socialreg ///
		gdppc pcturban polity, i(country) j(year)
drop if year==2015

outsheet * using "RAS.csv", comma nolabel replace
